{ *********************************************************************** }
{                                                                         }
{ Translated Header File                                                  }
{ Part of the Delphi Visual Component Library                             }
{                                                                         }
{ Original Header File Copyright (c) 1985-2004 Microsoft Corporation      }
{  All Rights Reserved.                                                   }
{                                                                         }
{ Translation Copyright (c) 1995-2004 Borland Software Corporation        }
{                                                                         }
{ *********************************************************************** }

unit Borland.Vcl.WinSvc platform;

{$ALIGN ON}
{$MINENUMSIZE 4}

interface

uses System.Runtime.InteropServices, System.Text, Windows;

//
// Constants
//

const

//
// Service database names
//
  SERVICES_ACTIVE_DATABASE     = 'ServicesActive';
  SERVICES_ACTIVE_DATABASEA     = 'ServicesActive';
  SERVICES_ACTIVE_DATABASEW     = 'ServicesActive';
  SERVICES_FAILED_DATABASE     = 'ServicesFailed';
  SERVICES_FAILED_DATABASEA     = 'ServicesFailed';
  SERVICES_FAILED_DATABASEW     = 'ServicesFailed';

//
// Character to designate that a name is a group
//
  SC_GROUP_IDENTIFIER          = '+';
  SC_GROUP_IDENTIFIERA          = '+';
  SC_GROUP_IDENTIFIERW          = '+';

//
// Value to indicate no change to an optional parameter
//
  SERVICE_NO_CHANGE              = $FFFFFFFF;

//
// Service State -- for Enum Requests (Bit Mask)
//
  SERVICE_ACTIVE                 = $00000001;
  SERVICE_INACTIVE               = $00000002;
  SERVICE_STATE_ALL              = (SERVICE_ACTIVE   or
                                    SERVICE_INACTIVE);

//
// Controls
//
  SERVICE_CONTROL_STOP           = $00000001;
  SERVICE_CONTROL_PAUSE          = $00000002;
  SERVICE_CONTROL_CONTINUE       = $00000003;
  SERVICE_CONTROL_INTERROGATE    = $00000004;
  SERVICE_CONTROL_SHUTDOWN       = $00000005;

//
// Service State -- for CurrentState
//
  SERVICE_STOPPED                = $00000001;
  SERVICE_START_PENDING          = $00000002;
  SERVICE_STOP_PENDING           = $00000003;
  SERVICE_RUNNING                = $00000004;
  SERVICE_CONTINUE_PENDING       = $00000005;
  SERVICE_PAUSE_PENDING          = $00000006;
  SERVICE_PAUSED                 = $00000007;

//
// Controls Accepted  (Bit Mask)
//
  SERVICE_ACCEPT_STOP            = $00000001;
  SERVICE_ACCEPT_PAUSE_CONTINUE  = $00000002;
  SERVICE_ACCEPT_SHUTDOWN        = $00000004;

//
// Service Control Manager object specific access types
//
  SC_MANAGER_CONNECT             = $0001;
  SC_MANAGER_CREATE_SERVICE      = $0002;
  SC_MANAGER_ENUMERATE_SERVICE   = $0004;
  SC_MANAGER_LOCK                = $0008;
  SC_MANAGER_QUERY_LOCK_STATUS   = $0010;
  SC_MANAGER_MODIFY_BOOT_CONFIG  = $0020;

  SC_MANAGER_ALL_ACCESS          = (STANDARD_RIGHTS_REQUIRED or
                                    SC_MANAGER_CONNECT or
                                    SC_MANAGER_CREATE_SERVICE or
                                    SC_MANAGER_ENUMERATE_SERVICE or
                                    SC_MANAGER_LOCK or
                                    SC_MANAGER_QUERY_LOCK_STATUS or
                                    SC_MANAGER_MODIFY_BOOT_CONFIG);

//
// Service object specific access type
//
  SERVICE_QUERY_CONFIG           = $0001;
  SERVICE_CHANGE_CONFIG          = $0002;
  SERVICE_QUERY_STATUS           = $0004;
  SERVICE_ENUMERATE_DEPENDENTS   = $0008;
  SERVICE_START                  = $0010;
  SERVICE_STOP                   = $0020;
  SERVICE_PAUSE_CONTINUE         = $0040;
  SERVICE_INTERROGATE            = $0080;
  SERVICE_USER_DEFINED_CONTROL   = $0100;

  SERVICE_ALL_ACCESS             = (STANDARD_RIGHTS_REQUIRED or
                                    SERVICE_QUERY_CONFIG or
                                    SERVICE_CHANGE_CONFIG or
                                    SERVICE_QUERY_STATUS or
                                    SERVICE_ENUMERATE_DEPENDENTS or
                                    SERVICE_START or
                                    SERVICE_STOP or
                                    SERVICE_PAUSE_CONTINUE or
                                    SERVICE_INTERROGATE or
                                    SERVICE_USER_DEFINED_CONTROL);


//
// Service Types (Bit Mask)
//
  SERVICE_KERNEL_DRIVER         = $00000001;
  SERVICE_FILE_SYSTEM_DRIVER    = $00000002;
  SERVICE_ADAPTER               = $00000004;
  SERVICE_RECOGNIZER_DRIVER     = $00000008;

  SERVICE_DRIVER                = (SERVICE_KERNEL_DRIVER or
                                   SERVICE_FILE_SYSTEM_DRIVER or
                                   SERVICE_RECOGNIZER_DRIVER);

  SERVICE_WIN32_OWN_PROCESS     = $00000010;
  SERVICE_WIN32_SHARE_PROCESS   = $00000020;
  SERVICE_WIN32                 = (SERVICE_WIN32_OWN_PROCESS or
                                   SERVICE_WIN32_SHARE_PROCESS);

  SERVICE_INTERACTIVE_PROCESS   = $00000100;

  SERVICE_TYPE_ALL              = (SERVICE_WIN32 or
                                  SERVICE_ADAPTER or
                                  SERVICE_DRIVER or
                                  SERVICE_INTERACTIVE_PROCESS);

//
// Start Type
//
  SERVICE_BOOT_START            = $00000000;
  SERVICE_SYSTEM_START          = $00000001;
  SERVICE_AUTO_START            = $00000002;
  SERVICE_DEMAND_START          = $00000003;
  SERVICE_DISABLED              = $00000004;

//
// Error control type
//
  SERVICE_ERROR_IGNORE          = $00000000;
  SERVICE_ERROR_NORMAL          = $00000001;
  SERVICE_ERROR_SEVERE          = $00000002;
  SERVICE_ERROR_CRITICAL        = $00000003;

type

//
// Handle Types
//

  SC_HANDLE = THandle;
  SERVICE_STATUS_HANDLE = DWORD;

//
// Service Status Structure
//

  [StructLayout(LayoutKind.Sequential)]
  _SERVICE_STATUS = record
    dwServiceType: DWORD;
    dwCurrentState: DWORD;
    dwControlsAccepted: DWORD;
    dwWin32ExitCode: DWORD;
    dwServiceSpecificExitCode: DWORD;
    dwCheckPoint: DWORD;
    dwWaitHint: DWORD;
  end;
  SERVICE_STATUS = _SERVICE_STATUS;
  TServiceStatus = _SERVICE_STATUS;

//
// Service Status Enumeration Structure
//
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _ENUM_SERVICE_STATUS = record
    [MarshalAs(UnmanagedType.LPTStr)]
    lpServiceName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpDisplayName: string;
    ServiceStatus: TServiceStatus;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _ENUM_SERVICE_STATUSA = record
    [MarshalAs(UnmanagedType.LPTStr)]
    lpServiceName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpDisplayName: string;
    ServiceStatus: TServiceStatus;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _ENUM_SERVICE_STATUSW = record
    [MarshalAs(UnmanagedType.LPTStr)]
    lpServiceName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpDisplayName: string;
    ServiceStatus: TServiceStatus;
  end;
  ENUM_SERVICE_STATUS = _ENUM_SERVICE_STATUS;
  ENUM_SERVICE_STATUSA = _ENUM_SERVICE_STATUSA;
  ENUM_SERVICE_STATUSW = _ENUM_SERVICE_STATUSW;
  TEnumServiceStatus = _ENUM_SERVICE_STATUS;
  TEnumServiceStatusA = _ENUM_SERVICE_STATUSA;
  TEnumServiceStatusW = _ENUM_SERVICE_STATUSW;

//
// Structures for the Lock API functions
//
  SC_LOCK = IntPtr; { Pointer }

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _QUERY_SERVICE_LOCK_STATUS = record
    fIsLocked: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpLockOwner: string;
    dwLockDuration: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _QUERY_SERVICE_LOCK_STATUSA = record
    fIsLocked: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpLockOwner: string;
    dwLockDuration: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _QUERY_SERVICE_LOCK_STATUSW = record
    fIsLocked: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpLockOwner: string;
    dwLockDuration: DWORD;
  end;
  QUERY_SERVICE_LOCK_STATUS = _QUERY_SERVICE_LOCK_STATUS;
  QUERY_SERVICE_LOCK_STATUSA = _QUERY_SERVICE_LOCK_STATUSA;
  QUERY_SERVICE_LOCK_STATUSW = _QUERY_SERVICE_LOCK_STATUSW;
  TQueryServiceLockStatus = _QUERY_SERVICE_LOCK_STATUS;
  TQueryServiceLockStatusA = _QUERY_SERVICE_LOCK_STATUSA;
  TQueryServiceLockStatusW = _QUERY_SERVICE_LOCK_STATUSW;

//
// Query Service Configuration Structure
//
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
   _QUERY_SERVICE_CONFIG = record
    dwServiceType: DWORD;
    dwStartType: DWORD;
    dwErrorControl: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpBinaryPathName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpLoadOrderGroup: string;
    dwTagId: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpDependencies: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpServiceStartName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpDisplayName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
   _QUERY_SERVICE_CONFIGA = record
    dwServiceType: DWORD;
    dwStartType: DWORD;
    dwErrorControl: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpBinaryPathName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpLoadOrderGroup: string;
    dwTagId: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpDependencies: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpServiceStartName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpDisplayName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
   _QUERY_SERVICE_CONFIGW = record
    dwServiceType: DWORD;
    dwStartType: DWORD;
    dwErrorControl: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpBinaryPathName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpLoadOrderGroup: string;
    dwTagId: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpDependencies: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpServiceStartName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpDisplayName: string;
  end;
  QUERY_SERVICE_CONFIG = _QUERY_SERVICE_CONFIG;
  QUERY_SERVICE_CONFIGA = _QUERY_SERVICE_CONFIGA;
  QUERY_SERVICE_CONFIGW = _QUERY_SERVICE_CONFIGW;
  TQueryServiceConfig = _QUERY_SERVICE_CONFIG;
  TQueryServiceConfigA = _QUERY_SERVICE_CONFIGA;
  TQueryServiceConfigW = _QUERY_SERVICE_CONFIGW;

//
// Function Prototype for the Service Main Function
//

  LPSERVICE_MAIN_FUNCTION = procedure (dwNumServicesArgs: DWORD;
    lpServiceArgVectors: IntPtr);
  LPSERVICE_MAIN_FUNCTIONA = procedure (dwNumServicesArgs: DWORD;
    lpServiceArgVectors: IntPtr);
  LPSERVICE_MAIN_FUNCTIONW = procedure (dwNumServicesArgs: DWORD;
    lpServiceArgVectors: IntPtr);
  TServiceMainFunction = LPSERVICE_MAIN_FUNCTION;
  TServiceMainFunctionA = LPSERVICE_MAIN_FUNCTIONA;
  TServiceMainFunctionW = LPSERVICE_MAIN_FUNCTIONW;

//
// Service Start Table
//
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _SERVICE_TABLE_ENTRY = record
    [MarshalAs(UnmanagedType.LPTStr)]
    lpServiceName: string;
    lpServiceProc: TServiceMainFunction;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _SERVICE_TABLE_ENTRYA = record
    [MarshalAs(UnmanagedType.LPTStr)]
    lpServiceName: string;
    lpServiceProc: TServiceMainFunctionA;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _SERVICE_TABLE_ENTRYW = record
    [MarshalAs(UnmanagedType.LPTStr)]
    lpServiceName: string;
    lpServiceProc: TServiceMainFunctionW;
  end;
  SERVICE_TABLE_ENTRY = _SERVICE_TABLE_ENTRY;
  SERVICE_TABLE_ENTRYA = _SERVICE_TABLE_ENTRYA;
  SERVICE_TABLE_ENTRYW = _SERVICE_TABLE_ENTRYW;
  TServiceTableEntry = _SERVICE_TABLE_ENTRY;
  TServiceTableEntryA = _SERVICE_TABLE_ENTRYA;
  TServiceTableEntryW = _SERVICE_TABLE_ENTRYW;

//
// Prototype for the Service Control Handler Function
//

  LPHANDLER_FUNCTION = procedure (dwControl: DWORD);
  THandlerFunction = LPHANDLER_FUNCTION;

///////////////////////////////////////////////////////////////////////////
// API Function Prototypes
///////////////////////////////////////////////////////////////////////////

function ChangeServiceConfig(hService: SC_HANDLE; dwServiceType, dwStartType,
  dwErrorControl: DWORD; lpBinaryPathName, lpLoadOrderGroup: string;
  out lpdwTagId: DWORD; lpDependencies, lpServiceStartName, lpPassword,
  lpDisplayName: string): BOOL;
function ChangeServiceConfigA(hService: SC_HANDLE; dwServiceType, dwStartType,
  dwErrorControl: DWORD; lpBinaryPathName, lpLoadOrderGroup: string;
  out lpdwTagId: DWORD; lpDependencies, lpServiceStartName, lpPassword,
  lpDisplayName: string): BOOL;
function ChangeServiceConfigW(hService: SC_HANDLE; dwServiceType, dwStartType,
  dwErrorControl: DWORD; lpBinaryPathName, lpLoadOrderGroup: string;
  out lpdwTagId: DWORD; lpDependencies, lpServiceStartName, lpPassword,
  lpDisplayName: string): BOOL;
function CloseServiceHandle(hSCObject: SC_HANDLE): BOOL;
function ControlService(hService: SC_HANDLE; dwControl: DWORD;
  out lpServiceStatus: TServiceStatus): BOOL;
function CreateService(hSCManager: SC_HANDLE; lpServiceName, lpDisplayName: string;
  dwDesiredAccess, dwServiceType, dwStartType, dwErrorControl: DWORD;
  lpBinaryPathName, lpLoadOrderGroup: string; out lpdwTagId: DWORD; lpDependencies,
  lpServiceStartName, lpPassword: string): SC_HANDLE; overload;
function CreateService(hSCManager: SC_HANDLE; lpServiceName, lpDisplayName: string;
  dwDesiredAccess, dwServiceType, dwStartType, dwErrorControl: DWORD;
  lpBinaryPathName, lpLoadOrderGroup: string; lpdwTagId: IntPtr; lpDependencies,
  lpServiceStartName, lpPassword: string): SC_HANDLE; overload;
function CreateService(hSCManager: SC_HANDLE; lpServiceName, lpDisplayName: string;
  dwDesiredAccess, dwServiceType, dwStartType, dwErrorControl: DWORD;
  lpBinaryPathName, lpLoadOrderGroup: string; out lpdwTagId: DWORD; lpDependencies: string;
  lpServiceStartName: IntPtr; lpPassword: string): SC_HANDLE; overload;
function CreateService(hSCManager: SC_HANDLE; lpServiceName, lpDisplayName: string;
  dwDesiredAccess, dwServiceType, dwStartType, dwErrorControl: DWORD;
  lpBinaryPathName, lpLoadOrderGroup: string; lpdwTagId: IntPtr; lpDependencies: string;
  lpServiceStartName: IntPtr; lpPassword: string): SC_HANDLE; overload;
function CreateServiceA(hSCManager: SC_HANDLE; lpServiceName, lpDisplayName: string;
  dwDesiredAccess, dwServiceType, dwStartType, dwErrorControl: DWORD;
  lpBinaryPathName, lpLoadOrderGroup: string; out lpdwTagId: DWORD; lpDependencies,
  lpServiceStartName, lpPassword: string): SC_HANDLE;
function CreateServiceW(hSCManager: SC_HANDLE; lpServiceName, lpDisplayName: string;
  dwDesiredAccess, dwServiceType, dwStartType, dwErrorControl: DWORD;
  lpBinaryPathName, lpLoadOrderGroup: string; out lpdwTagId: DWORD; lpDependencies,
  lpServiceStartName, lpPassword: string): SC_HANDLE;
function DeleteService(hService: SC_HANDLE): BOOL;
function EnumDependentServices(hService: SC_HANDLE; dwServiceState: DWORD;
  [out] lpServices: array of TEnumServiceStatus; cbBufSize: DWORD;
  out pcbBytesNeeded, lpServicesReturned: DWORD): BOOL;
function EnumDependentServicesA(hService: SC_HANDLE; dwServiceState: DWORD;
  [out] lpServices: array of TEnumServiceStatusA; cbBufSize: DWORD;
  out pcbBytesNeeded, lpServicesReturned: DWORD): BOOL;
function EnumDependentServicesW(hService: SC_HANDLE; dwServiceState: DWORD;
  [out] lpServices: array of TEnumServiceStatusW; cbBufSize: DWORD;
  out pcbBytesNeeded, lpServicesReturned: DWORD): BOOL;
function EnumServicesStatus(hSCManager: SC_HANDLE; dwServiceType,
  dwServiceState: DWORD; [out] lpServices: array of TEnumServiceStatus; cbBufSize: DWORD;
  out pcbBytesNeeded, lpServicesReturned: DWORD; var lpResumeHandle: DWORD): BOOL;
function EnumServicesStatusA(hSCManager: SC_HANDLE; dwServiceType,
  dwServiceState: DWORD; [out] lpServices: array of TEnumServiceStatusA; cbBufSize: DWORD;
  out pcbBytesNeeded, lpServicesReturned: DWORD; var lpResumeHandle: DWORD): BOOL;
function EnumServicesStatusW(hSCManager: SC_HANDLE; dwServiceType,
  dwServiceState: DWORD; [out] lpServices: array of TEnumServiceStatusW; cbBufSize: DWORD;
  out pcbBytesNeeded, lpServicesReturned: DWORD; var lpResumeHandle: DWORD): BOOL;
function GetServiceKeyName(hSCManager: SC_HANDLE; lpDisplayName: string;
  lpServiceName: StringBuilder; var lpcchBuffer: DWORD): BOOL;
function GetServiceKeyNameA(hSCManager: SC_HANDLE; lpDisplayName: string;
  lpServiceName: StringBuilder; var lpcchBuffer: DWORD): BOOL;
function GetServiceKeyNameW(hSCManager: SC_HANDLE; lpDisplayName: string;
  lpServiceName: StringBuilder; var lpcchBuffer: DWORD): BOOL;
function GetServiceDisplayName(hSCManager: SC_HANDLE; lpServiceName: string;
  lpDisplayName: StringBuilder; var lpcchBuffer: DWORD): BOOL;
function GetServiceDisplayNameA(hSCManager: SC_HANDLE; lpServiceName: string;
  lpDisplayName: StringBuilder; var lpcchBuffer: DWORD): BOOL;
function GetServiceDisplayNameW(hSCManager: SC_HANDLE; lpServiceName: string;
  lpDisplayName: StringBuilder; var lpcchBuffer: DWORD): BOOL;
function LockServiceDatabase(hSCManager: SC_HANDLE): SC_LOCK;
function NotifyBootConfigStatus(BootAcceptable: BOOL): BOOL;
function OpenSCManager(lpMachineName, lpDatabaseName: string;
  dwDesiredAccess: DWORD): SC_HANDLE; overload;
function OpenSCManager(lpMachineName: string; lpDatabaseName: IntPtr;
  dwDesiredAccess: DWORD): SC_HANDLE; overload;
function OpenSCManagerA(lpMachineName, lpDatabaseName: string;
  dwDesiredAccess: DWORD): SC_HANDLE;
function OpenSCManagerW(lpMachineName, lpDatabaseName: string;
  dwDesiredAccess: DWORD): SC_HANDLE;
function OpenService(hSCManager: SC_HANDLE; lpServiceName: string;
  dwDesiredAccess: DWORD): SC_HANDLE;
function OpenServiceA(hSCManager: SC_HANDLE; lpServiceName: string;
  dwDesiredAccess: DWORD): SC_HANDLE;
function OpenServiceW(hSCManager: SC_HANDLE; lpServiceName: string;
  dwDesiredAccess: DWORD): SC_HANDLE;
function QueryServiceConfig(hService: SC_HANDLE;
  out lpServiceConfig: TQueryServiceConfig; cbBufSize: DWORD;
  out pcbBytesNeeded: DWORD): BOOL;
function QueryServiceConfigA(hService: SC_HANDLE;
  out lpServiceConfig: TQueryServiceConfigA; cbBufSize: DWORD;
  out pcbBytesNeeded: DWORD): BOOL;
function QueryServiceConfigW(hService: SC_HANDLE;
  out lpServiceConfig: TQueryServiceConfigW; cbBufSize: DWORD;
  out pcbBytesNeeded: DWORD): BOOL;
function QueryServiceLockStatus(hSCManager: SC_HANDLE;
  out lpLockStatus: TQueryServiceLockStatus; cbBufSize: DWORD;
  out pcbBytesNeeded: DWORD): BOOL;
function QueryServiceLockStatusA(hSCManager: SC_HANDLE;
  out lpLockStatus: TQueryServiceLockStatusA; cbBufSize: DWORD;
  out pcbBytesNeeded: DWORD): BOOL;
function QueryServiceLockStatusW(hSCManager: SC_HANDLE;
  out lpLockStatus: TQueryServiceLockStatusW; cbBufSize: DWORD;
  out pcbBytesNeeded: DWORD): BOOL;
function QueryServiceObjectSecurity(hService: SC_HANDLE;
  dwSecurityInformation: SECURITY_INFORMATION;
  lpSecurityDescriptor: PSECURITY_DESCRIPTOR; cbBufSize: DWORD;
  out pcbBytesNeeded: DWORD): BOOL;
function QueryServiceStatus(hService: SC_HANDLE;
  out lpServiceStatus: TServiceStatus): BOOL;
function RegisterServiceCtrlHandler(lpServiceName: string;
  lpHandlerProc: ThandlerFunction): SERVICE_STATUS_HANDLE;
function RegisterServiceCtrlHandlerA(lpServiceName: string;
  lpHandlerProc: ThandlerFunction): SERVICE_STATUS_HANDLE;
function RegisterServiceCtrlHandlerW(lpServiceName: string;
  lpHandlerProc: ThandlerFunction): SERVICE_STATUS_HANDLE;
function SetServiceObjectSecurity(hService: SC_HANDLE;
  dwSecurityInformation: SECURITY_INFORMATION;
  lpSecurityDescriptor: PSECURITY_DESCRIPTOR): BOOL;
function SetServiceStatus(hServiceStatus: SERVICE_STATUS_HANDLE;
  const lpServiceStatus: TServiceStatus): BOOL;
function StartServiceCtrlDispatcher([in] lpServiceStartTable: array of TServiceTableEntry): BOOL;
function StartServiceCtrlDispatcherA([in] lpServiceStartTable: array of TServiceTableEntryA): BOOL;
function StartServiceCtrlDispatcherW([in] lpServiceStartTable: array of TServiceTableEntryW): BOOL;
function StartService(hService: SC_HANDLE; dwNumServiceArgs: DWORD;
  lpServiceArgVectors: IntPtr): BOOL;
function StartServiceA(hService: SC_HANDLE; dwNumServiceArgs: DWORD;
  lpServiceArgVectors: IntPtr): BOOL;
function StartServiceW(hService: SC_HANDLE; dwNumServiceArgs: DWORD;
  lpServiceArgVectors: IntPtr): BOOL;
function UnlockServiceDatabase(ScLock: SC_LOCK): BOOL; 

implementation

const
  advapi32 = 'advapi32.dll';    

[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ChangeServiceConfig')]
function ChangeServiceConfig; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ChangeServiceConfigA')]
function ChangeServiceConfigA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ChangeServiceConfigW')]
function ChangeServiceConfigW; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CloseServiceHandle')]
function CloseServiceHandle; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ControlService')]
function ControlService; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateService')]
function CreateService(hSCManager: SC_HANDLE; lpServiceName, lpDisplayName: string;
  dwDesiredAccess, dwServiceType, dwStartType, dwErrorControl: DWORD;
  lpBinaryPathName, lpLoadOrderGroup: string; out lpdwTagId: DWORD; lpDependencies,
  lpServiceStartName, lpPassword: string): SC_HANDLE; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateService')]
function CreateService(hSCManager: SC_HANDLE; lpServiceName, lpDisplayName: string;
  dwDesiredAccess, dwServiceType, dwStartType, dwErrorControl: DWORD;
  lpBinaryPathName, lpLoadOrderGroup: string; lpdwTagId: IntPtr; lpDependencies,
  lpServiceStartName, lpPassword: string): SC_HANDLE; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateService')]
function CreateService(hSCManager: SC_HANDLE; lpServiceName, lpDisplayName: string;
  dwDesiredAccess, dwServiceType, dwStartType, dwErrorControl: DWORD;
  lpBinaryPathName, lpLoadOrderGroup: string; out lpdwTagId: DWORD; lpDependencies: string;
  lpServiceStartName: IntPtr; lpPassword: string): SC_HANDLE; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'CreateService')]
function CreateService(hSCManager: SC_HANDLE; lpServiceName, lpDisplayName: string;
  dwDesiredAccess, dwServiceType, dwStartType, dwErrorControl: DWORD;
  lpBinaryPathName, lpLoadOrderGroup: string; lpdwTagId: IntPtr; lpDependencies: string;
  lpServiceStartName: IntPtr; lpPassword: string): SC_HANDLE; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CreateServiceA')]
function CreateServiceA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'CreateServiceW')]
function CreateServiceW; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeleteService')]
function DeleteService; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumDependentServices')]
function EnumDependentServices; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumDependentServicesA')]
function EnumDependentServicesA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumDependentServicesW')]
function EnumDependentServicesW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumServicesStatus')]
function EnumServicesStatus; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumServicesStatusA')]
function EnumServicesStatusA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumServicesStatusW')]
function EnumServicesStatusW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetServiceKeyName')]
function GetServiceKeyName; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetServiceKeyNameA')]
function GetServiceKeyNameA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetServiceKeyNameW')]
function GetServiceKeyNameW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetServiceDisplayName')]
function GetServiceDisplayName; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetServiceDisplayNameA')]
function GetServiceDisplayNameA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetServiceDisplayNameW')]
function GetServiceDisplayNameW; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'LockServiceDatabase')]
function LockServiceDatabase; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'NotifyBootConfigStatus')]
function NotifyBootConfigStatus; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'OpenSCManager')]
function OpenSCManager(lpMachineName, lpDatabaseName: string;
  dwDesiredAccess: DWORD): SC_HANDLE; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'OpenSCManager')]
function OpenSCManager(lpMachineName: string; lpDatabaseName: IntPtr;
  dwDesiredAccess: DWORD): SC_HANDLE; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OpenSCManagerA')]
function OpenSCManagerA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OpenSCManagerW')]
function OpenSCManagerW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'OpenService')]
function OpenService; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OpenServiceA')]
function OpenServiceA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OpenServiceW')]
function OpenServiceW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'QueryServiceConfig')]
function QueryServiceConfig; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'QueryServiceConfigA')]
function QueryServiceConfigA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'QueryServiceConfigW')]
function QueryServiceConfigW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'QueryServiceLockStatus')]
function QueryServiceLockStatus; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'QueryServiceLockStatusA')]
function QueryServiceLockStatusA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'QueryServiceLockStatusW')]
function QueryServiceLockStatusW; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'QueryServiceObjectSecurity')]
function QueryServiceObjectSecurity; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'QueryServiceStatus')]
function QueryServiceStatus; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'RegisterServiceCtrlHandler')]
function RegisterServiceCtrlHandler; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'RegisterServiceCtrlHandlerA')]
function RegisterServiceCtrlHandlerA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'RegisterServiceCtrlHandlerW')]
function RegisterServiceCtrlHandlerW; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetServiceObjectSecurity')]
function SetServiceObjectSecurity; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetServiceStatus')]
function SetServiceStatus; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'StartServiceCtrlDispatcher')]
function StartServiceCtrlDispatcher; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'StartServiceCtrlDispatcherA')]
function StartServiceCtrlDispatcherA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'StartServiceCtrlDispatcherW')]
function StartServiceCtrlDispatcherW; external;
[DllImport(advapi32, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'StartService')]
function StartService; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'StartServiceA')]
function StartServiceA; external;
[DllImport(advapi32, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'StartServiceW')]
function StartServiceW; external;
[DllImport(advapi32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'UnlockServiceDatabase')]
function UnlockServiceDatabase; external;

end.

